 ; Ŀ
 ;   Xswitch - get out of the current drawing and into a selected xref.    
 ;   Also Xback - return to the original drawing.                          
 ;   Copyright 1997 by Rocket Software                                     
 ;   Every system relies on the intelligence of the user.  Remove this     
 ;   requirement and you remove the need for a user.                       
 ; 

 ; Ŀ
 ;   Opnr - open a drawing name passed as the sole variable.               
 ; 
 (DEFUN OPNR (nampth / filnam eoq)
  (command ".open")
  (if (/= (getvar "dbmod") 0)
      (progn
           (initget "Yes No")
           (setq eoq (getkword "Save changes? <Y>: "))               
           (if (/= eoq "No")
               (command "n")
               (command "y"))))
  (command nampth)
 (princ))
 ; Ŀ
 ;   Opnr end.                                                             
 ; 

 ; Ŀ
 ;   Teli - write the name of the current drawing to a file.               
 ; 
 (DEFUN TELI (/ filnam eoq)
  (setq cnam (strcat (getvar "dwgprefix") (getvar "dwgname")))
  (if (and (/= cnam "UNNAMED")
           (setq fn (open "prevdwg.txt" "w")))
      (progn
           (write-line cnam fn)
           (close fn)))
 (princ))
 ; Ŀ
 ;   Teli end.                                                             
 ; 

 ; Ŀ
 ;   Xback - return to the original drawing.                               
 ; 
 (DEFUN C:XBACK (/ fn lin)
  (if (and (setq fn (open "prevdwg.txt" "r"))
           (setq lin (read-line fn)))
      (progn
           (close fn)
           (opnr lin)))
 (princ))
 ; Ŀ
 ;   Xback end.                                                            
 ; 

 ; Ŀ
 ;   Xswitch.                                                              
 ; 
 (DEFUN C:XSWITCH (/ rew bldat sevnt namlst pxref enampt nampth blnam)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   First find all referenced xref definitions in the block tables - if   
 ;   there is only one it can be offered as the default.  Possibly some    
 ;   other use can be made of the data otherwise.  Later: the first one    
 ;   can always be offered as the default if there are any.                
 ; 
  (setq rew t)
  (while (setq bldat (tblnext "block" rew))
         (setq rew ())
         (setq sevnt (cdr (assoc 70 bldat)))
         (if (and (= 4 (logand 4 sevnt)) (= 32 (logand 32 sevnt)))
             (setq namlst (append namlst (list (list (cdr (assoc 2 bldat))
                                                   (cdr (assoc 1 bldat))))))))
 ; Ŀ
 ;   Should now have a list of lists of referenced xrefs: block name,      
 ;   filename.                                                             
 ; 
  (if namlst
      (progn
           (setq pxref (car namlst))
           (setq enampt (entsel (strcat "Xref <" (car pxref) ">: ")))
           (if (null enampt)
               (setq nampth (cadr pxref))
               (if (setq blnam (cdr (assoc 2 (entget (car enampt)))))
                   (if (setq bldat (tblsearch "block" blnam))
                       (setq nampth (cdr (assoc 1 bldat)))))))
      (if (setq blnam (cdr (assoc 2 (entget (car (entsel "Xref: "))))))
          (if (setq bldat (tblsearch "block" blnam))
              (setq nampth (cdr (assoc 1 bldat))))))
 ; Ŀ
 ;   If there is a name in Nampth then save the current drawing name to    
 ;   a file and open the new drawing.                                      
 ; 
  (if nampth
     (progn
          (teli)
          (opnr nampth)))
 (princ))

(write-line "C:XSWITCH/C:XBACK")
(princ)